/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import cz.insophy.inplan.planning.mokos.MinimalTimeBound;
import java.util.Date;
import java.util.Iterator;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class MinimalTimeBoundLowLevel
implements MinimalTimeBound {
    private static final Object ABS_SPEC = new Object(){

        public String toString() {
            return "SIMPLE";
        }
    };
    private Object[] ownersRaw = new Object[0];
    private Object[] specifiersRaw = new Object[0];
    private long[] timesRaw = new long[0];
    private Object[] specifiersRefined = new Object[0];
    private long[] timesRefined = new long[0];
    private MinimalTimeBound.BoundDefinition boundDef = new MinimalTimeBound.BoundDefinition(Long.MIN_VALUE);
    private int wModCnt;
    private int rModCnt;

    MinimalTimeBoundLowLevel() {
    }

    @Override
    public MinimalTimeBound.BoundDefinition getBound() {
        this.updateForReading();
        return this.boundDef;
    }

    @Override
    public void updateSimpleBound(Object owner, long time) {
        this.actualizeBounds(owner, ABS_SPEC, time);
    }

    @Override
    public void updateCompositeBound(Object owner, Object specifier, long time) {
        this.actualizeBounds(owner, specifier, time);
    }

    @Override
    @Nonnull
    public Iterable<MinimalTimeBound.BoundInformation> getBoundInformation() {
        return new Iterable<MinimalTimeBound.BoundInformation>(){

            @Override
            public Iterator<MinimalTimeBound.BoundInformation> iterator() {
                return new Iterator<MinimalTimeBound.BoundInformation>(){
                    private int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < MinimalTimeBoundLowLevel.this.ownersRaw.length;
                    }

                    @Override
                    public MinimalTimeBound.BoundInformation next() {
                        return new LowLevelBoundInformation(this.i++);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void updateForReading() {
        if (this.rModCnt != this.wModCnt) {
            this.actualizeBoundDef();
            this.rModCnt = this.wModCnt;
        }
    }

    private void actualizeBounds(Object owner, Object specifier, long time) {
        if (this.actualizeRawArrays(owner, specifier, time)) {
            this.actualizeRefinedArrays(specifier);
            ++this.wModCnt;
        }
    }

    private boolean actualizeRawArrays(Object owner, Object specifier, long time) {
        int i = this.indexOf(owner, specifier);
        if (i >= 0) {
            if (this.timesRaw[i] == time) {
                return false;
            }
            this.removeRawAtIdx(i);
        } else {
            this.expandRawArrays();
        }
        int timePosition = this.timePosition(time);
        this.addRawAtIdx(owner, specifier, time, timePosition);
        return true;
    }

    private void actualizeRefinedArrays(Object specifier) {
        if (MinimalTimeBoundLowLevel.indexOf(this.specifiersRefined, specifier) < 0) {
            this.expandRefinedArrays();
            this.specifiersRefined[this.specifiersRefined.length - 1] = specifier;
        }
        this.sortSpecifiers();
    }

    private void actualizeBoundDef() {
        boolean absFirst;
        this.boundDef.specifiers.clear();
        boolean bl = absFirst = this.specifiersRefined[0] == ABS_SPEC;
        if (absFirst || MinimalTimeBoundLowLevel.indexOf(this.specifiersRefined, ABS_SPEC) < 0) {
            if (absFirst && this.specifiersRefined.length == 1) {
                this.boundDef.time = this.timesRefined[0];
            } else {
                int firstIdx = absFirst ? 1 : 0;
                this.boundDef.time = this.timesRefined[firstIdx];
                for (int i = firstIdx; i < this.specifiersRefined.length && this.timesRefined[i] == this.boundDef.time; ++i) {
                    this.boundDef.specifiers.add(this.specifiersRefined[i]);
                }
            }
        } else {
            int i;
            for (i = 0; i < this.specifiersRefined.length; ++i) {
                if (this.specifiersRefined[i] != ABS_SPEC) continue;
                this.boundDef.time = this.timesRefined[i];
                break;
            }
            for (i = 0; i < this.specifiersRefined.length && this.timesRefined[i] <= this.boundDef.time; ++i) {
                if (this.specifiersRefined[i] == ABS_SPEC) continue;
                this.boundDef.specifiers.add(this.specifiersRefined[i]);
            }
        }
    }

    private void sortSpecifiers() {
        int sortedIdx = this.specifiersRefined.length;
        for (int i = this.specifiersRaw.length - 1; i >= 0; --i) {
            Object specifier = this.specifiersRaw[i];
            long time = this.timesRaw[i];
            if (MinimalTimeBoundLowLevel.indexOf(this.specifiersRefined, specifier, sortedIdx) >= 0) continue;
            this.specifiersRefined[--sortedIdx] = specifier;
            this.timesRefined[sortedIdx] = time;
        }
    }

    private int timePosition(long time) {
        int position = this.timesRaw.length - 1;
        for (int i = 0; i < this.timesRaw.length - 1; ++i) {
            if (this.timesRaw[i] < time) continue;
            return i;
        }
        return position;
    }

    private void expandRefinedArrays() {
        this.timesRefined = MinimalTimeBoundLowLevel.expandArray(this.timesRefined);
        this.specifiersRefined = MinimalTimeBoundLowLevel.expandArray(this.specifiersRefined);
    }

    private void expandRawArrays() {
        this.timesRaw = MinimalTimeBoundLowLevel.expandArray(this.timesRaw);
        this.ownersRaw = MinimalTimeBoundLowLevel.expandArray(this.ownersRaw);
        this.specifiersRaw = MinimalTimeBoundLowLevel.expandArray(this.specifiersRaw);
    }

    private int indexOf(Object owner, Object specifier) {
        for (int i = 0; i < this.ownersRaw.length; ++i) {
            if (!Objects.equals(this.ownersRaw[i], owner) || !Objects.equals(this.specifiersRaw[i], specifier)) continue;
            return i;
        }
        return -1;
    }

    private void removeRawAtIdx(int idx) {
        System.arraycopy(this.timesRaw, idx + 1, this.timesRaw, idx, this.timesRaw.length - (idx + 1));
        MinimalTimeBoundLowLevel.removeAtIdx(this.ownersRaw, idx);
        MinimalTimeBoundLowLevel.removeAtIdx(this.specifiersRaw, idx);
    }

    private void addRawAtIdx(Object owner, Object specifier, long time, int idx) {
        System.arraycopy(this.timesRaw, idx, this.timesRaw, idx + 1, this.timesRaw.length - (idx + 1));
        this.timesRaw[idx] = time;
        MinimalTimeBoundLowLevel.addAtIdx(this.ownersRaw, owner, idx);
        MinimalTimeBoundLowLevel.addAtIdx(this.specifiersRaw, specifier, idx);
    }

    private static Object[] expandArray(Object[] orig) {
        Object[] expanded = new Object[orig.length + 1];
        System.arraycopy(orig, 0, expanded, 0, orig.length);
        return expanded;
    }

    private static long[] expandArray(long[] orig) {
        long[] expanded = new long[orig.length + 1];
        System.arraycopy(orig, 0, expanded, 0, orig.length);
        return expanded;
    }

    private static void removeAtIdx(Object[] array, int idx) {
        System.arraycopy(array, idx + 1, array, idx, array.length - (idx + 1));
    }

    private static void addAtIdx(Object[] array, Object obj, int idx) {
        System.arraycopy(array, idx, array, idx + 1, array.length - (idx + 1));
        array[idx] = obj;
    }

    private static int indexOf(Object[] array, Object obj) {
        return MinimalTimeBoundLowLevel.indexOf(array, obj, 0);
    }

    private static int indexOf(Object[] array, Object obj, int idx) {
        for (int i = idx; i < array.length; ++i) {
            if (!Objects.equals(array[i], obj)) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < this.timesRaw.length; ++i) {
            b.append(this.timesRaw[i]);
            b.append(' ');
            b.append(new Date(this.timesRaw[i]));
            b.append(' ');
            b.append(this.specifiersRaw[i]);
            b.append(' ');
            b.append(this.ownersRaw[i]);
            b.append('\n');
        }
        return b.toString();
    }

    private class LowLevelBoundInformation
    implements MinimalTimeBound.BoundInformation {
        final int i;

        private LowLevelBoundInformation(int i) {
            this.i = i;
        }

        @Override
        @Nonnull
        public Object getOwner() {
            return MinimalTimeBoundLowLevel.this.ownersRaw[this.i];
        }

        @Override
        @Nullable
        public Object getSpecifier() {
            return MinimalTimeBoundLowLevel.this.specifiersRaw[this.i] == ABS_SPEC ? null : MinimalTimeBoundLowLevel.this.specifiersRaw[this.i];
        }

        @Override
        public long getTime() {
            return MinimalTimeBoundLowLevel.this.timesRaw[this.i];
        }

        @Override
        public boolean isComposite() {
            return MinimalTimeBoundLowLevel.this.specifiersRaw[this.i] != ABS_SPEC;
        }
    }
}

